﻿using log4net;
using Microsoft.Azure.WebJobs;
using Microsoft.Azure.WebJobs.Host;
using Microsoft.Azure.WebJobs.Host.Config;
using Microsoft.Extensions.DependencyInjection;
using Newtonsoft.Json.Linq;
using VA.PPMS.Context;
using VA.PPMS.Context.Interface;
using VA.PPMS.IWS.AddressValidationService.Interface;
using VA.PPMS.IWS.BatchService.Interface;
using VA.PPMS.IWS.BlobService.Interface;
using VA.PPMS.IWS.Common;
using VA.PPMS.IWS.CreateResponseService.Interface;
using VA.PPMS.IWS.Functions.Configuration;
using VA.PPMS.IWS.Functions.Configuration.Interface;
using VA.PPMS.IWS.MappingService.Interface;
using VA.PPMS.IWS.MappingService.Mappers;
using VA.PPMS.IWS.OrchestrationService.Interface;
using VA.PPMS.IWS.PersistenceService.Interface;
using VA.PPMS.IWS.ProviderAgreementService.Interface;
using VA.PPMS.IWS.ProviderService.Interface;
using VA.PPMS.IWS.QueueService.Interface;
using VA.PPMS.IWS.SchemaValidationService.Interface;
using VA.PPMS.IWS.TableService.Interface;
using VA.PPMS.IWS.ValidationDataService.Data;
using VA.PPMS.IWS.ValidationDataService.Interface;

namespace VA.PPMS.IWS.Functions
{
    public class InjectConfiguration : IExtensionConfigProvider
    {
        public void Initialize(ExtensionConfigContext context)
        {
            context.ApplyConfig(this);
            var config = context.GetConfig(this);
            var services = new ServiceCollection();
            RegisterServices(services, config);

            var serviceProvider = services.BuildServiceProvider(true);
            context.AddBindingRule<InjectAttribute>().Bind(new InjectBindingProvider(serviceProvider));
            
            var registry = context.Config.GetService<IExtensionRegistry>();
            var filter = new ScopeCleanupFilter();

            registry.RegisterExtension(typeof(IFunctionInvocationFilter), filter);
            registry.RegisterExtension(typeof(IFunctionExceptionFilter), filter);
        }

        private static void RegisterServices(IServiceCollection services, JObject config)
        {
            services.AddSingleton<IIwsConfiguration, IwsConfiguration>();
            services.AddSingleton<INameResolver, ConfigNameResolver>();
            services.AddTransient<IPpmsContextHelper, PpmsContextHelper>();
            services.AddTransient<IPpmsHelper, PpmsHelper>();
            services.AddTransient<MapAuthorizedOfficialToCrm>();
            services.AddTransient<MapBoardCertificationToCrm>();
            services.AddTransient<MapCareSiteToCrm>();
            services.AddTransient<MapCcnIdentifierToCrm>();
            services.AddTransient<MapContactToCrm>();
            services.AddTransient<MapDeaScheduleToCrm>();
            services.AddTransient<MapLicensureToCrm>();
            services.AddTransient<MapMedicalEducationToCrm>();
            services.AddTransient<MapNpiToCrm>();
            services.AddTransient<MapOtherIdentifierToCrm>();
            services.AddTransient<MapOtherNameToCrm>();
            services.AddTransient<MapProviderCredentialToCrm>();
            services.AddTransient<MapProviderServiceToCrm>();
            services.AddTransient<MapTaxonomyToCrm>();
            services.AddTransient<MapTinToCrm>();
            services.AddTransient<MapProviderToCrm>();
            services.AddTransient<IBlobService, BlobService.BlobService>();
            services.AddTransient<IMappingService, MappingService.MappingService>();
            services.AddTransient<IPersistenceService, PersistenceService.PersistenceService>();
            services.AddTransient<ISchemaValidationService, SchemaValidationService.SchemaValidationService>();
            services.AddTransient<IOrchestrationService, OrchestrationService.OrchestrationService>();
            services.AddTransient<IQueueService, QueueService.QueueService>();
            services.AddTransient<ICreateResponseService, CreateResponseService.CreateResponseService>();
            services.AddTransient<ITableService, TableService.TableService>();
            services.AddTransient<IValidationDataService, ValidationDataService.ValidationDataService>();
            services.AddTransient<IBatchService, BatchService.BatchService>();
            services.AddTransient<IProviderService, ProviderService.ProviderService>();
            services.AddTransient<NppesData>();
            services.AddTransient<IProviderAgreementService, ProviderAgreementService.ProviderAgreementService>();
            services.AddTransient<IAddressValidationService, AddressValidationService.AddressValidationService>();

            var doc = XmlHelper.LoadParameters(config["Log4NetConfigSettings"].Value<string>());
            var element = doc.DocumentElement;
            log4net.Config.XmlConfigurator.Configure(element);
            var logger = LogManager.GetLogger("AzureLogger");

            services.AddSingleton(logger);
        }
    }
}